<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateOperatorRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        $id = $this->route('operator'); // Model binding হলে Operator instance, নাহলে id—দুটোই কাজ করবে
        $operatorId = is_object($id) ? $id->id : $id;

        return [
            'name'       => ['required','string','max:255'],
            'code'       => ['required','string','max:100', Rule::unique('operators','code')->ignore($operatorId)],
            'status'     => ['required','in:active,inactive'],
            'sort_order' => ['nullable','integer','min:0'],
            'logo'       => ['nullable','image','mimes:jpg,jpeg,png,webp','max:2048'],
        ];
    }
}