<?php 

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreUserRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name'  => ['required','string','max:255'],
            'phone' => ['required','string','max:20','unique:users,phone'],
            // এখন ইমেইল আবশ্যিক, কারণ OTP যাবে
            'email' => ['required','email','max:255','unique:users,email'],
            'avatar' => ['nullable','image','mimes:jpg,jpeg,png,webp'],
        ];
    }

    public function attributes(): array
    {
        return [
            'name'   => 'পূর্ণ নাম',
            'phone'  => 'ফোন নম্বর',
            'email'  => 'ইমেইল',
            'avatar' => 'প্রোফাইল ছবি',
        ];
    }
}
