<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreUserPinRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'pin' => ['required', 'digits:4'],
        ];
    }

    public function messages(): array
    {
        return [
            'pin.required'   => 'PIN লিখুন।',
            'pin.digits'     => 'PIN ৪-সংখ্যার হতে হবে।'
        ];
    }
}
