<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreUserPasswordRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'password' => ['required', 'digits:6'],
        ];
    }

    public function messages(): array
    {
        return [
            'password.required'   => 'পাসওয়ার্ড লিখুন।',
            'password.digits'     => 'পাসওয়ার্ড ৬-সংখ্যার হতে হবে।'
        ];
    }
}
