<?php 

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreUserCredentialsRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            // ৬ digit numeric password
            'password' => ['required','digits:6','confirmed'],
            // ৪ digit numeric PIN
            'pin' => ['required','digits:4','same:pin_confirmation'],
            'pin_confirmation' => ['required','digits:4'],
        ];
    }

    public function attributes(): array
    {
        return [
            'password' => 'পাসওয়ার্ড',
            'pin'      => 'PIN',
        ];
    }
}
