<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreOperatorRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        return [
            'name'       => ['required','string','max:255'],
            'code'       => ['required','string','max:100','unique:operators,code'],
            'status'     => ['required','in:active,inactive'],
            'sort_order' => ['nullable','integer','min:0'],
            'logo'       => ['nullable','image','mimes:jpg,jpeg,png,webp','max:2048'],
        ];
    }
}