<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreContactMessageRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        return [
            'name'     => ['required','string','max:120'],
            'email'    => ['required','email','max:160'],
            'subject'  => ['required','string','max:180'],
            'whatsapp' => ['nullable','string','max:40'],
            'message'  => ['required','string','min:5'],
        ];
    }
}