<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SendMoneyRequest extends FormRequest
{
    public function authorize(): bool { return auth()->check(); }

    public function rules(): array
    {
        return [
            'to_phone' => ['required','regex:/^\+?\d{10,15}$/'],
            'amount'   => ['required','numeric','min:1','max:1000000'],
            'note'     => ['nullable','string','max:160'],
            'login_pin'  => ['required', 'digits:4'], // ⬅️ important
            'idempotency_key' => ['nullable','string','max:64'],
        ];
    }

    public function messages(): array
    {
        return [
            'to_phone.regex' => 'Enter a valid phone (10–15 digits).',
        ];
    }
}
