<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class ProfileUpdateRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->check();
    }

    public function rules(): array
    {
        $userId = $this->user()->id;

        return [
            'name' => ['required', 'string', 'max:255'],

            // nullable + unique (ignore current user)
            'email' => [
                'nullable', 'email', 'max:255',
                Rule::unique('users', 'email')->ignore($userId),
            ],

            'phone' => [
                'nullable', 'string', 'max:20',
                Rule::unique('users', 'phone')->ignore($userId),
            ],

            'avatar' => ['nullable', 'image', 'mimes:jpg,jpeg,png,webp'], // 2MB

            // পাসওয়ার্ড ঐচ্ছিক; দিলে কনফার্মড হতে হবে
            'password' => ['nullable', 'confirmed', 'min:8'],
        ];
    }

    public function messages(): array
    {
        return [
            'name.required' => 'নাম দেওয়া বাধ্যতামূলক।',
            'email.email' => 'সঠিক ইমেইল অ্যাড্রেস দিন।',
            'password.confirmed' => 'পাসওয়ার্ড কনফার্ম মিলে না।',
        ];
    }
}
