<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class LoginRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'email'    => ['required', 'email'],
            // fixed 6-digit numeric password
            'password' => ['required', 'digits:6'],
            'remember' => ['sometimes', 'boolean'],
        ];
    }
}
