<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class EnsureUserRole
{
    /**
     * Usage: ->middleware('role:user') or ->middleware('role:admin') or ->middleware('role:user,admin')
     */
    public function handle(Request $request, Closure $next, ...$roles)
    {
        if (!Auth::check()) {
            return redirect()->route('login');
        }

        $user = Auth::user();

        // যদি এই রুটে ইউজারের role অনুমোদিত হয়
        if (in_array($user->role, $roles, true)) {
            return $next($request);
        }

        // অন্য role হলে নিজ নিজ ড্যাশবোর্ডে রিডাইরেক্ট
        return redirect()->route($user->role === 'admin' ? 'admin.dashboard' : 'dashboard');
    }
}
