<?php


namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;

use App\Models\Setting;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class SettingController extends Controller
{
    public function index()
    {
        // সব সেটিংস দেখাবে + bulk update form
        $settings = Setting::orderBy('key')->get();
        return view('backend.settings.index', compact('settings'));
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'key'   => 'required|string|max:191|unique:settings,key',
            'value' => 'nullable|string',
        ]);
        Setting::create($data);
        return redirect(url('/admin/settings'))->with('success', 'Setting added.');
    }

    public function update(Request $request)
    {
        // bulk update: inputs আসবে arrays হিসেবে: keys[], values[]
        $items = $request->get('items', []);
        if (is_array($items)) {
            foreach ($items as $id => $row) {
                $setting = Setting::find($id);
                if (!$setting) continue;

                // key change হলে unique ভায়োলেশন এড়াই
                $request->validate([
                    "items.$id.key" => [
                        'required','string','max:191',
                        Rule::unique('settings','key')->ignore($setting->id),
                    ],
                    "items.$id.value" => ['nullable','string']
                ]);

                $setting->update([
                    'key'   => $row['key'] ?? $setting->key,
                    'value' => $row['value'] ?? $setting->value,
                ]);
            }
        }
        return redirect(url('/admin/settings'))->with('success', 'Settings updated.');
    }

    public function destroy($id)
    {
        Setting::findOrFail($id)->delete();
        return redirect(url('/admin/settings'))->with('success', 'Setting deleted.');
    }
}
