<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\RewardConversion;
use Illuminate\Http\Request;

class RewardConversionManager extends Controller
{
    public function __construct()
    {
        // $this->middleware(['auth']);
        // $this->middleware('can:view-rewards');
    }

    public function index(Request $request)
    {
        $request->validate([
            'q' => ['nullable','string','max:100'],
        ]);

        $query = RewardConversion::with('user')->latest();

        if ($q = $request->string('q')->toString()) {
            $query->where(function($qq) use ($q) {
                $qq->where('ref','like',"%{$q}%")
                   ->orWhereHas('user', fn($uq) => $uq->where('name','like',"%{$q}%"));
            });
        }

        $conversions = $query->paginate(30)->withQueryString();

        return view('admin.reward_conversions.index', compact('conversions'));
    }

    // NEW: Delete conversion (hard delete). চাইলে softDeletes ব্যবহার করতে পারো।
    public function destroy(RewardConversion $conversion)
    {
        $conversion->delete();
        return back()->with('ok', 'Conversion deleted.');
    }
}
