<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\CompanySetup;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class CompanySetupController extends Controller
{
    public function index()
    {
        $companySetups = CompanySetup::latest()->paginate(12);
        return view('admin.company_setups.index', compact('companySetups'));
    }

    public function create()
    {
        return view('admin.company_setups.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'company_name'     => ['nullable','string','max:255'],
            'about_company'    => ['nullable','string'],
            'phone_number'     => ['nullable','string','max:255'],
            'whatsapp_number'  => ['nullable','string','max:255'],
            'telegram_link'    => ['nullable','url'],
            'facebook_link'    => ['nullable','url'],
            'email'            => ['nullable','email','max:255'],
            'address'          => ['nullable','string','max:255'],
            'fav_icon'         => ['nullable','image','mimes:png,jpg,jpeg,webp,ico','max:2048'],
            'logo'             => ['nullable','image','mimes:png,jpg,jpeg,webp,svg','max:4096'],
        ]);

        if ($request->hasFile('fav_icon')) {
            $data['fav_icon'] = $request->file('fav_icon')->store('company_setups/favicons', 'public');
        }
        if ($request->hasFile('logo')) {
            $data['logo'] = $request->file('logo')->store('company_setups/logos', 'public');
        }

        CompanySetup::create($data);

        return redirect()->route('company-setups.index')->with('status', 'Company created successfully.');
    }

    public function edit(CompanySetup $companySetup)
    {
        return view('admin.company_setups.edit', compact('companySetup'));
    }

    public function update(Request $request, CompanySetup $companySetup)
    {
        $data = $request->validate([
            'company_name'     => ['nullable','string','max:255'],
            'about_company'    => ['nullable','string'],
            'phone_number'     => ['nullable','string','max:255'],
            'whatsapp_number'  => ['nullable','string','max:255'],
            'telegram_link'    => ['nullable','url'],
            'facebook_link'    => ['nullable','url'],
            'email'            => ['nullable','email','max:255'],
            'address'          => ['nullable','string','max:255'],
            'fav_icon'         => ['nullable','image','mimes:png,jpg,jpeg,webp,ico','max:2048'],
            'logo'             => ['nullable','image','mimes:png,jpg,jpeg,webp,svg','max:4096'],
        ]);

        if ($request->hasFile('fav_icon')) {
            if ($companySetup->fav_icon) {
                Storage::disk('public')->delete($companySetup->fav_icon);
            }
            $data['fav_icon'] = $request->file('fav_icon')->store('company_setups/favicons', 'public');
        }

        if ($request->hasFile('logo')) {
            if ($companySetup->logo) {
                Storage::disk('public')->delete($companySetup->logo);
            }
            $data['logo'] = $request->file('logo')->store('company_setups/logos', 'public');
        }

        $companySetup->update($data);

        return redirect()->route('company-setups.index')->with('status', 'Company updated successfully.');
    }

    public function destroy(CompanySetup $companySetup)
    {
        if ($companySetup->fav_icon) {
            Storage::disk('public')->delete($companySetup->fav_icon);
        }
        if ($companySetup->logo) {
            Storage::disk('public')->delete($companySetup->logo);
        }

        $companySetup->delete();

        return redirect()->route('company-setups.index')->with('status', 'Company deleted.');
    }
}
