<?php 

// app/Http/Controllers/User/RateController.php
namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\ExchangeCountry;
use Illuminate\Http\Request;

class RateController extends Controller
{
    public function index()
    {
        $countries = ExchangeCountry::where('is_active', true)
            ->orderBy('position')->orderBy('name')->get();

        // ডিফল্ট প্রথম দেশ
        $first = optional($countries->first());
        return view('frontend.rates.index', compact('countries','first'));
    }

    public function show(ExchangeCountry $country)
    {
        abort_if(! $country->is_active, 404);
        $countries = ExchangeCountry::where('is_active', true)
            ->orderBy('position')->orderBy('name')->get();
        return view('frontend.rates.show', compact('country','countries'));
    }
}
