<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules\Password;
use Illuminate\Support\Facades\Storage;
use App\Http\Requests\ProfileUpdateRequest;

class ProfileController extends Controller
{
    public function index(Request $request)
    {
        return view('frontend.account.index', ['user' => $request->user()]);
    }

    public function changePassword(Request $request)
    {
        $request->validate([
            'old_password' => ['required', 'string'],
            'password'     => ['required', 'confirmed', Password::min(8)],
        ]);

        $user = $request->user();

        if (! Hash::check($request->old_password, $user->password)) {
            return back()->withErrors(['old_password' => 'Old password is incorrect.'])->withInput();
        }

        $user->forceFill([
            'password' => Hash::make($request->password),
        ])->save();

        return back()->with('status', 'Password updated successfully.');
    }



    public function edit(Request $request)
{
$user = $request->user();
return view('frontend.profile.edit', compact('user'));
}


public function update(ProfileUpdateRequest $request)
{
$user = $request->user();


$data = $request->validated();


// যদি ইমেইল পরিবর্তন হয় তবে ভেরিফিকেশন রিসেট
if (array_key_exists('email', $data) && $data['email'] !== $user->email) {
$user->email_verified_at = null;
}


// পাসওয়ার্ড ফাঁকা থাকলে আপডেট করবেন না
if (empty($data['password'] ?? null)) {
unset($data['password']);
}


// অ্যাভাটার আপলোড
if ($request->hasFile('avatar')) {
// পুরনো ফাইল ডিলিট (থাকলে)
if ($user->avatar && Storage::disk('public')->exists($user->avatar)) {
Storage::disk('public')->delete($user->avatar);
}


$path = $request->file('avatar')->store('avatars', 'public');
$data['avatar'] = $path; // DB-তে রিলেটিভ পাথ রাখছি
}


$user->update($data);


return redirect()->route('profile.edit')->with('status', 'প্রোফাইল আপডেট হয়েছে!');
}
}

 