<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;

class NoticeActionController extends Controller
{
    public function count(Request $request)
    {
        $count = $request->user()->notices()->wherePivotNull('read_at')->count();
        return response()->json(['count'=>$count]);
    }

    // সব Unread -> Read (এবং নতুন কাউন্ট রিটার্ন)
    public function readAll(Request $request)
    {
        $user = $request->user();
        $ids = $user->notices()->pluck('notices.id')->all();
        if ($ids) {
            $user->notices()->wherePivotNull('read_at')
                ->updateExistingPivot($ids, ['read_at'=>now()]);
        }
        $count = $user->notices()->wherePivotNull('read_at')->count();
        return response()->json(['ok'=>true,'count'=>$count]);
    }
}
