<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function dashboard(Request $request)
    {
        $user = $request->user();

        // লেটেস্ট একটি নোটিস (সবার সাথে আগেই attach করা আছে)
        $latestNotice = $user->notices()
            ->select('notices.id','title','body','notices.created_at')
            ->orderByDesc('notices.created_at')
            ->first();

        // navbar ব্যাজ চাইলে
        $unreadCount = $user->notices()->wherePivotNull('read_at')->count();

        return view('frontend.dashboard', compact('latestNotice','unreadCount'));
    }
}
