<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\DepositPackage;
use App\Models\Setting;

class DepositPageController extends Controller
{
    public function index()
    {
        $packages = DepositPackage::active()->orderBy('sort_order')->orderBy('id')->get();

        $banner = [
            'title'    => Setting::get('deposit_banner_title', 'বিশেষ ডিপোজিট অফার'),
            'subtitle' => Setting::get('deposit_banner_subtitle', 'প্রতিটি ডিপোজিটে পাবেন আকর্ষণীয় বোনাস!'),
            'chip'     => Setting::get('deposit_banner_chip', '٪ ৫% সরকারী বোনাস সহ'),
        ];

        $rulesText = Setting::get('deposit_rules_text', 'কোম্পানির নির্দেশনা অনুযায়ী টাকা জমা করবেন...');
        $contact = [
            'phone'    => Setting::get('contact_phone', '+8801XXXXXXXXX'),
            'provider' => Setting::get('contact_provider', 'Remittance Pay'),
        ];

        return view('frontend.deposits.index', compact('packages','banner','rulesText','contact'));
    }
}
