<?php

namespace App\Http\Controllers;

use App\Models\BellNotification;
use Illuminate\Http\Request;

class BellNotificationController extends Controller
{
    // See More page
    public function index(Request $request)
    {
        $query = BellNotification::query()->latest();

        // optional filter: /notifications?filter=unread
        if ($request->get('filter') === 'unread') {
            $query->whereNull('read_at');
        }

        $notifications = $query->paginate(20);
        $unreadCount   = BellNotification::whereNull('read_at')->count();

        return view('admin.notifications.index', compact('notifications', 'unreadCount'));
    }

    // Header real-time poll (JSON + partial html)
    public function poll(Request $request)
    {
        $notifications = BellNotification::latest()
            ->take(5)
            ->get();

        // সব unread count
        $unreadCount = BellNotification::whereNull('read_at')->count();

        return response()->json([
            'count' => $unreadCount,
            'html'  => view('admin.partials.notifications-list', compact('notifications'))->render(),
        ]);
    }

    // Single notification read
    public function markRead(BellNotification $notification)
    {
        if (is_null($notification->read_at)) {
            $notification->update(['read_at' => now()]);
        }

        $unreadCount = BellNotification::whereNull('read_at')->count();

        return response()->json([
            'success' => true,
            'count'   => $unreadCount,
        ]);
    }

    // All notifications read
    public function markAllRead()
    {
        BellNotification::whereNull('read_at')->update(['read_at' => now()]);

        return response()->json([
            'success' => true,
            'count'   => 0,
        ]);
    }
}
