<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\PinRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class PinController extends Controller
{
    public function show()
    {
        if (! Auth::check()) {
            return redirect()->route('login');
        }

        return view('frontend.auth.pin');
    }

    public function verify(PinRequest $request)
    {
        $user = Auth::user();

        if (! $user) {
            return redirect()->route('login');
        }

        $pin = $request->pin;

        // প্রথমবার login হলে PIN সেট করা হবে
        if (! $user->login_pin) {
            $user->login_pin = $pin;
            $user->save();

            session(['pin.verified' => true]);

            return redirect()->route($user->isAdmin() ? 'admin.dashboard' : 'dashboard')
                ->with('success', 'PIN সেট হয়েছে এবং লগইন সম্পন্ন হয়েছে।');
        }

        // আগের PIN verify
        if (! Hash::check($pin, $user->login_pin)) {
            return back()->withErrors([
                'pin' => 'PIN সঠিক নয়।',
            ]);
        }

        session(['pin.verified' => true]);

        return redirect()->route($user->isAdmin() ? 'admin.dashboard' : 'dashboard')
            ->with('success', 'PIN সঠিক, ড্যাশবোর্ডে ঢুকেছেন।');
    }
}
