<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;

class SettingController extends Controller
{
    public function editDeposit()
    {
        $data = [
            'deposit_banner_title'    => Setting::get('deposit_banner_title', 'বিশেষ ডিপোজিট অফার'),
            'deposit_banner_subtitle' => Setting::get('deposit_banner_subtitle', 'প্রতিটি ডিপোজিটে পাবেন আকর্ষণীয় বোনাস!'),
            'deposit_banner_chip'     => Setting::get('deposit_banner_chip', '% ৫% সরকারী বোনাস সহ'),
            'deposit_rules_text'      => Setting::get('deposit_rules_text', 'কম্পানির নির্দিষ্ট নিয়মাবলী অনুযায়ী টাকা জমা করবেন...'),
            'contact_phone'           => Setting::get('contact_phone', '+8801XXXXXXXXX'),
            'contact_provider'        => Setting::get('contact_provider', 'Remittance Pay'),
        ];
        return view('admin.settings.deposit', compact('data'));
    }

    public function updateDeposit(Request $request)
    {
        $data = $request->validate([
            'deposit_banner_title'    => ['required','string','max:100'],
            'deposit_banner_subtitle' => ['required','string','max:200'],
            'deposit_banner_chip'     => ['nullable','string','max:50'],
            'deposit_rules_text'      => ['required','string'],
            'contact_phone'           => ['required','string','max:30'],
            'contact_provider'        => ['required','string','max:60'],
        ]);

        foreach ($data as $k=>$v) {
            Setting::set($k, $v);
        }

        return back()->with('success','Deposit settings updated.');
    }
}
