<?php 


// app/Http/Controllers/Admin/RateAdminController.php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ExchangeCountry;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class RateAdminController extends Controller
{
    public function index() {
        $countries = ExchangeCountry::orderBy('position')->orderBy('name')->get();
        return view('admin.rates.index', compact('countries'));
    }

    public function store(Request $r) {
        $data = $r->validate([
            'name'=>'required|string|max:60',
            'currency_name'=>'required|string|max:60',
            'unit_label'=>'nullable|string|max:40',
            'rate_bdt'=>'required|numeric|min:0',
            'flag_path'=>'nullable|string|max:255',
            'header_bg'=>'nullable|string|max:20',
            'share_title_bn'=>'nullable|string|max:120',
            'share_title_en'=>'nullable|string|max:120',
            'share_desc_bn'=>'nullable|string',
            'share_desc_en'=>'nullable|string',
            'position'=>'nullable|integer|min:0',
            'is_active'=>'required|boolean',
        ]);
        $data['slug'] = Str::slug($data['name']);
        ExchangeCountry::updateOrCreate(['slug'=>$data['slug']], $data);
        return back()->with('success','Saved.');
    }

    public function update(Request $r, ExchangeCountry $country) {
        $data = $r->validate([
            'currency_name'=>'required|string|max:60',
            'unit_label'=>'nullable|string|max:40',
            'rate_bdt'=>'required|numeric|min:0',
            'flag_path'=>'nullable|string|max:255',
            'header_bg'=>'nullable|string|max:20',
            'share_title_bn'=>'nullable|string|max:120',
            'share_title_en'=>'nullable|string|max:120',
            'share_desc_bn'=>'nullable|string',
            'share_desc_en'=>'nullable|string',
            'position'=>'nullable|integer|min:0',
            'is_active'=>'required|boolean',
        ]);
        $country->update($data);
        return back()->with('success','Updated.');
    }

    public function toggle(ExchangeCountry $country) {
        $country->update(['is_active'=>!$country->is_active]);
        return back()->with('success','Visibility toggled.');
    }
}
