<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Purchase;
use Illuminate\Http\Request;

class PurchaseController extends Controller
{
    public function index(Request $request)
    {
        $q = trim((string)$request->get('q'));
        $status = $request->get('status');

        $purchases = Purchase::with(['user','offer'])
            ->when($q, function($qb) use ($q) {
                $qb->where('msisdn','like',"%{$q}%")
                   ->orWhere('txn_id','like',"%{$q}%")
                   ->orWhereHas('user', fn($u) => $u->where('name','like',"%{$q}%"))
                   ->orWhereHas('offer', fn($o) => $o->where('title','like',"%{$q}%"));
            })
            ->when($status, fn($qb) => $qb->where('status',$status))
            ->orderByDesc('id')
            ->paginate(20)
            ->withQueryString();

        return view('admin.purchases.index', compact('purchases','q','status'));
    }

    public function show(Purchase $purchase)
    {
        $purchase->load(['user','offer.operator']);
        return view('admin.purchases.show', compact('purchase'));
    }
}
