<?php 
// app/Http/Controllers/Admin/MobileGatewayController.php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\MobileGateway;
use Illuminate\Http\Request;

class MobileGatewayController extends Controller
{
    public function index() {
        $gateways = MobileGateway::orderBy('id')->get();
        return view('admin.gateways.index', compact('gateways'));
    }

    public function storeOrUpdate(Request $request, ?MobileGateway $gateway = null) {
        $data = $request->validate([
            'name'            => ['required','string','max:50'],
            'code'            => ['required','string','max:20'],
            'min_limit'       => ['required','numeric','min:0'],
            'max_limit'       => ['required','numeric','min:0'],
            'is_active'       => ['required','boolean'],
            'flat_fee'        => ['required','numeric','min:0'],
            'percent_fee'     => ['required','numeric','min:0'],
            'min_commission'  => ['required','numeric','min:0'],
            'max_commission'  => ['required','numeric','min:0'],
        ]);

        $gateway?->update($data) ?? MobileGateway::create($data);

        return back()->with('success', 'সেভ হয়েছে।');
    }
}
