<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ContactMessage;
use Illuminate\Http\Request;

class ContactInboxController extends Controller
{
    // public function __construct()
    // {   $this->middleware(['auth','can:admin-area']); }

    public function index(Request $request)
    {
        $status = $request->get('status'); // unread|read|archived|null
        $q = trim($request->get('q', ''));

        $messages = ContactMessage::when($q, function($query) use ($q){
                $query->where(fn($w)=>$w->where('name','like',"%$q%")
                    ->orWhere('email','like',"%$q%")
                    ->orWhere('subject','like',"%$q%"));
            })
            ->status($status)
            ->latest()
            ->paginate(20)
            ->withQueryString();

        $counts = [
            'unread'   => ContactMessage::where('status','unread')->count(),
            'read'     => ContactMessage::where('status','read')->count(),
            'archived' => ContactMessage::where('status','archived')->count(),
        ];

        return view('admin.contact.index', compact('messages','counts','status','q'));
    }

    public function show(ContactMessage $message)
    {
        if ($message->status === 'unread') {
            $message->update(['status' => 'read', 'read_at' => now()]);
        }
        return view('admin.contact.show', compact('message'));
    }

    public function markRead(ContactMessage $message)
    {   $message->update(['status' => 'read', 'read_at' => now()]); return back(); }

    public function markUnread(ContactMessage $message)
    {   $message->update(['status' => 'unread', 'read_at' => null]); return back(); }

    public function archive(ContactMessage $message)
    {   $message->update(['status' => 'archived']); return back(); }

    public function destroy(ContactMessage $message)
    {   $message->delete(); return back()->with('success','Deleted'); }
}