<?php 

// app/Http/Controllers/Admin/BankAdminController.php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Bank;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class BankAdminController extends Controller
{
    public function index() {
        $banks = Bank::orderBy('name')->paginate(40);
        return view('admin.banks.index', compact('banks'));
    }

    public function storeOrUpdate(Request $r) {
        $data = $r->validate([
            'name'            => ['required','string','max:150'],
            'min_transaction' => ['required','numeric','min:0'],
            'reward_percent'  => ['required','numeric','min:0','max:100'],
            'is_active'       => ['required','boolean'],
        ]);

        $data['slug'] = Str::slug($data['name']);
        Bank::updateOrCreate(['slug' => $data['slug']], $data);

        return back()->with('success','Saved.');
    }
}
