<?php

namespace App\Events;

use App\Models\Transfer;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class SendMoneyRequested implements ShouldBroadcastNow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public Transfer $transfer;

    /**
     * Create a new event instance.
     */
    public function __construct(Transfer $transfer)
    {
        // fresh relation সহ পাঠালে JS side এ user info লাগলে বের করা সহজ হয়
        $this->transfer = $transfer->fresh(['fromUser', 'toUser']);
    }

    /**
     * কোন channel এ broadcast হবে
     */
    public function broadcastOn(): array
    {
        // public channel (চাইলে private-send-money-channel ও করতে পারো)
        return ['send-money-channel'];
    }

    /**
     * JS side এ যে event name শুনবে
     */
    public function broadcastAs(): string
    {
        return 'send-money-event';
    }

    /**
     * Frontend এ পাঠানোর ডাটা
     */
    public function broadcastWith(): array
    {
        return [
            'id'          => $this->transfer->id,
            'amount'      => (float) $this->transfer->amount,
            'status'      => $this->transfer->status,
            'from_user'   => [
                'id'    => $this->transfer->fromUser?->id,
                'name'  => $this->transfer->fromUser?->name,
                'phone' => $this->transfer->fromUser?->phone,
            ],
            'to_user'     => [
                'id'    => $this->transfer->toUser?->id,
                'name'  => $this->transfer->toUser?->name,
                'phone' => $this->transfer->toUser?->phone,
            ],
            'note'        => $this->transfer->note,
            'created_at'  => optional($this->transfer->created_at)->toDateTimeString(),
        ];
    }
}
