<?php

namespace App\Events;

use App\Models\RewardConversion;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class RewardConverted implements ShouldBroadcastNow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public RewardConversion $conversion;

    /**
     * Create a new event instance.
     */
    public function __construct(RewardConversion $conversion)
    {
        // user relation সহ লোড করে রাখি
        $this->conversion = $conversion->load('user');
    }

    /**
     * কোন channel এ broadcast হবে
     */
    public function broadcastOn(): array
    {
        return ['reward-conversion-channel'];
    }

    /**
     * JS side এ event নাম
     */
    public function broadcastAs(): string
    {
        return 'reward-conversion-event';
    }

    /**
     * Frontend এ যাবে যে payload
     */
    public function broadcastWith(): array
    {
        return [
            'id'      => $this->conversion->id,
            'user'    => [
                'id'    => $this->conversion->user?->id,
                'name'  => $this->conversion->user?->name,
                'phone' => $this->conversion->user?->phone,
            ],
            'points'  => (int) $this->conversion->points,
            'amount'  => (float) $this->conversion->amount,
            'rate'    => [
                'rate_points' => (int) $this->conversion->rate_points,
                'rate_amount' => (float) $this->conversion->rate_amount,
            ],
            'ref'     => $this->conversion->ref,
            'created_at' => optional($this->conversion->created_at)->toDateTimeString(),

            // কিছু extra helpful info
            'current_balance' => (float) ($this->conversion->user->balance ?? 0),
            'current_points'  => (int) ($this->conversion->user->reward_points ?? 0),
        ];
    }
}
