<?php

namespace App\Events;

use App\Models\Purchase;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class OfferPurchaseRequested implements ShouldBroadcastNow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public Purchase $purchase;

    /**
     * Create a new event instance.
     */
    public function __construct(Purchase $purchase)
    {
        // relation গুলো ready রাখতে fresh নিই
        $this->purchase = $purchase->load('user', 'offer');
    }

    /**
     * কোন channel এ broadcast হবে
     */
    public function broadcastOn(): array
    {
        // অন্যগুলার মত আলাদা channel নাম
        return ['offer-purchase-channel'];
    }

    /**
     * JS side এ যে event name শুনবে
     */
    public function broadcastAs(): string
    {
        return 'offer-purchase-event';
    }

    /**
     * Frontend এ পাঠানোর ডাটা
     */
    public function broadcastWith(): array
    {
        return [
            'id'         => $this->purchase->id,
            'price'      => (float) $this->purchase->price,
            'status'     => $this->purchase->status,
            'txn_id'     => $this->purchase->txn_id,
            'msisdn'     => $this->purchase->msisdn,
            'user'       => [
                'id'    => $this->purchase->user?->id,
                'name'  => $this->purchase->user?->name,
                'phone' => $this->purchase->user?->phone,
            ],
            'offer'      => [
                'id'    => $this->purchase->offer?->id,
                'title' => $this->purchase->offer?->title ?? $this->purchase->offer?->name,
            ],
            'created_at' => optional($this->purchase->created_at)->toDateTimeString(),
        ];
    }
}
