<?php

namespace App\Events;

use App\Models\LoanApplication;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class LoanApplicationSubmitted implements ShouldBroadcastNow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public LoanApplication $loan;

    public function __construct(LoanApplication $loan)
    {
        // চাইলে এখানে relation লোড করে নিতে পারো
        $this->loan = $loan->loadMissing('user');
    }

    public function broadcastOn(): array
    {
        // public channel
        return ['loan-application-channel'];
    }

    public function broadcastAs(): string
    {
        return 'loan-application-event';
    }

    public function broadcastWith(): array
    {
        return [
            'id'              => $this->loan->id,
            'user_id'         => $this->loan->user_id,
            'user_name'       => $this->loan->user?->name,
            'loan_amount'     => (float) $this->loan->loan_amount,
            'loan_period'     => (int) $this->loan->loan_period,
            'interest_rate'   => (float) $this->loan->interest_rate,
            'estimated_total' => (float) $this->loan->estimated_total,
            'status'          => $this->loan->status, // usually 'pending'
            'created_at'      => optional($this->loan->created_at)->toDateTimeString(),
        ];
    }
}
