<?php

namespace App\Events;

use App\Models\AddMoneyCardSubmit;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class CardAddMoney implements ShouldBroadcastNow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public AddMoneyCardSubmit $submit;

    /**
     * Create a new event instance.
     */
    public function __construct(AddMoneyCardSubmit $submit)
    {
        $this->submit = $submit->fresh(['user', 'card']);
    }

    /**
     * Broadcast channel name
     */
    public function broadcastOn(): array
    {
        // 👉 JS side: pusher.subscribe('card-add-money-channel')
        return ['card-add-money-channel'];
    }

    /**
     * Broadcast event name
     */
    public function broadcastAs(): string
    {
        // 👉 JS side: channel.bind('card-add-money-event', ...)
        return 'card-add-money-event';
    }

    /**
     * Data payload frontend এ যাবে
     */
    public function broadcastWith(): array
    {
        return [
            'id'          => $this->submit->id,
            'amount'      => (float) $this->submit->amount,
            'status'      => $this->submit->status,
            'user_id'     => $this->submit->user_id,
            'user_name'   => optional($this->submit->user)->name,
            'card_brand'  => optional($this->submit->card)->brand,
            'reference'   => $this->submit->reference_code,
            'created_at'  => optional($this->submit->created_at)->toDateTimeString(),
        ];
    }
}
