<?php

namespace App\Events\Bills;

use App\Models\BillPayment;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class BillPaymentSubmitted implements ShouldBroadcastNow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public BillPayment $payment;

    public function __construct(BillPayment $payment)
    {
        $this->payment = $payment;
    }

    public function broadcastOn(): array
    {
        // ✅ Pusher channel name
        return ['bill-payment-channel'];
    }

    public function broadcastAs(): string
    {
        // ✅ event name
        return 'bill-payment-event';
    }

    public function broadcastWith(): array
    {
        return [
            'id'           => $this->payment->id,
            'user_id'      => $this->payment->user_id,
            'amount'       => $this->payment->amount,
            'status'       => $this->payment->status,
            'biller_id'    => $this->payment->biller_id,
            'biller_name'  => optional($this->payment->biller)->name,
            'account_name' => $this->payment->account_name,
            'account_no'   => $this->payment->account_no,
            'txn_id'       => $this->payment->txn_id,
            'created_at'   => optional($this->payment->created_at)->toDateTimeString(),
        ];
    }
}
