<?php

namespace App\Events;

use App\Models\BankTransfer;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class BankTransferRequested implements ShouldBroadcastNow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public BankTransfer $transfer;

    /**
     * Create a new event instance.
     */
    public function __construct(BankTransfer $transfer)
    {
        // relation লাগলে load করে নিচ্ছি
        $this->transfer = $transfer->loadMissing('bank', 'user');
    }

    /**
     * কোন channel এ broadcast হবে
     */
    public function broadcastOn(): array
    {
        // JS: "bank-transfer-channel"
        return [new Channel('bank-transfer-channel')];
    }

    /**
     * JS side event name
     */
    public function broadcastAs(): string
    {
        // JS: "bank-transfer-event"
        return 'bank-transfer-event';
    }

    /**
     * JS এ যে data যাবে
     */
    public function broadcastWith(): array
    {
        return [
            'id'              => $this->transfer->id,
            'amount'          => (float) $this->transfer->amount,
            'status'          => $this->transfer->status,
            'bank_id'         => $this->transfer->bank_id,
            'bank_name'       => optional($this->transfer->bank)->name,
            'account_name'    => $this->transfer->account_name,
            'account_number'  => $this->transfer->account_number,
            'branch_name'     => $this->transfer->branch_name,
            'user_id'         => $this->transfer->user_id,
            'user_name'       => optional($this->transfer->user)->name,
            'created_at'      => optional($this->transfer->created_at)->toDateTimeString(),
        ];
    }
}
