<?php

namespace App\Events;

use App\Models\AddmoneyBank;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class BankAddMoney implements ShouldBroadcastNow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public AddmoneyBank $bank;

    public function __construct(AddmoneyBank $bank)
    {
        $this->bank = $bank;
    }

    public function broadcastOn(): array
    {
        // নতুন আলাদা channel
        return ['bank-add-money-channel'];
    }

    public function broadcastAs(): string
    {
        return 'bank-add-money-event';
    }

    public function broadcastWith(): array
    {
        return [
            'id'        => $this->bank->id,
            'amount'    => $this->bank->amount,
            'status'    => $this->bank->status,
            'user_id'   => $this->bank->user_id,
            'reference' => $this->bank->reference,
            'created_at'=> optional($this->bank->created_at)->toDateTimeString(),
            'type'      => 'bank',
        ];
    }
}
