<?php
// app/Events/AdminActionEvent.php
namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow; // ⬅️ এটা ইউজ করুন
use Illuminate\Queue\SerializesModels;

class AdminActionEvent implements ShouldBroadcastNow
{
    use SerializesModels;

    public string $title;
    public string $message;
    public array $meta;

    public function __construct(string $title, string $message, array $meta = [])
    {
        $this->title = $title;
        $this->message = $message;
        $this->meta = $meta;
    }

    public function broadcastOn()
    {
        return new PrivateChannel('admin.notifications');
    }

    public function broadcastAs()
    {
        return 'admin.action';
    }

    public function broadcastWith(): array
    {
        return [
            'title' => $this->title,
            'message' => $this->message,
            'meta' => $this->meta,
            'time' => now()->toIso8601String(),
        ];
    }
}
