<?php

namespace App\Events;

use App\Models\Deposit;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class AddMoney implements ShouldBroadcastNow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public Deposit $deposit;

    public function __construct(Deposit $deposit)
    {
        // fresh load করলে টাইম/রিলেশন সব সঠিক আসে
        $this->deposit = $deposit->fresh();
    }

    /**
     * কোন channel এ broadcast হবে
     */
    public function broadcastOn(): Channel|array
    {
        // public channel
        return new Channel('add-money-channel');
    }

    /**
     * frontend এ event name
     */
    public function broadcastAs(): string
    {
        return 'add-money-event';
    }

    /**
     * payload data
     */
    public function broadcastWith(): array
    {
        return [
            'id'        => $this->deposit->id,
            'amount'    => $this->deposit->amount,
            'status'    => $this->deposit->status,
            'user_id'   => $this->deposit->user_id,
            'reference' => $this->deposit->reference,
            'created_at'=> $this->deposit->created_at?->toDateTimeString(),
        ];
    }
}
